/*
 * 	sample3.t				version 3.0
 *	by Kevin Forchione		( Lysseus@msn.com )
 *	Copyright (c) 1999. 	All Rights Reserved.
 *
 *  SAMPLE DEMONSTRATION GAME FOR SENSE.T
 *
 *  This file demonstrates sense.t used to construct a composite room,
 *  which in this example is a 3x3 composite with visibility sense-
 *  passing.
 *
 *  This file requires HTML TADS 2.5.1 or later.
 *
 *  You may modify and use this file in any way you want, provided that
 *	if you redistribute modified copies of this file in source form, the
 *  copies must include the original copyright notice (including this
 *  paragraph), and must be clearly marked as modified from the original
 *  version.
 *
 *------------------------------------------------------------------------------
 *		Revision History
 *------------------------------------------------------------------------------
 *		02-Nov-99:	Creation.
 *      18-Jan-00:  Updated for sense 3.0
 */

#define USE_CONTAINMENT

#include <adv.t>
#include <std.t>
#include <sense.t>
#include <doors.t>

startroom: room
    sdesc = "Narrow Passage"
    ldesc = "The roof of this long narrow passage has collapsed. The
        only exit is to the north. "
    north = sHall
;

sHall: room
    sdesc = "South End of Great Hall"
    ldesc = "You are standing in the south end of the Great Hall."
    north = middleHall
    ne = eHall
    east = seHall
    south = startroom
    west = swHall
    nw = wHall
    seeInto = [ middleHall eHall seHall swHall wHall ]
    isListed = nil
;

swHall: room
    sdesc = "Southwest End of Great Hall"
    ldesc = "You are standing in the southwest end of the Great Hall."
    north = wHall
    ne = middleHall
    east = sHall
    seeInto = [ wHall middleHall sHall ]
    isListed = nil
;

seHall: room
    sdesc = "Southeast End of Great Hall"
    ldesc = "You are standing in the southeast end of the Great Hall."
    north = eHall
    west = sHall
    nw = middleHall
    seeInto = [ eHall sHall middleHall ]
    isListed = nil
;

wHall: room
    sdesc = "West End of Great Hall"
    ldesc = "You are standing in the west end of the Great Hall."
    north = nwHall
    ne = nHall
    east = middleHall
    se = sHall
    south = swHall
    seeInto = [ nwHall nHall middleHall sHall swHall ]
    isListed = nil
;

middleHall: room
    sdesc = "Middle of Great Hall"
    ldesc = "You are standing in the middle of the Great Hall."
    north = nHall
    ne = neHall
    east = eHall
    se = seHall
    south = sHall
    sw = swHall
    west = wHall
    nw = nwHall
    seeInto = [ nHall neHall eHall seHall sHall swHall wHall nwHall ]
    isListed = nil
;

apple: fooditem
    location = middleHall
    noun = 'apple'
    sdesc = "apple"
    adesc = "an apple"
;

eHall: room
    sdesc = "East End of Great Hall"
    ldesc = "You are standing in the east end of the Great Hall."
    north = neHall
    south = seHall
    sw = sHall
    west = middleHall
    nw = nHall
    seeInto = [ neHall seHall sHall middleHall nHall ]
    isListed = nil
;

book: readable
    location = eHall
    noun = 'book'
    adjective = 'magic'
    sdesc = "book of magic"
    adesc_remote = "a small, black book"
    readdesc = "It has only one word printed on each of its 
        pages: XYZZY! "
;

nwHall: room
    sdesc = "Northwest End of Great Hall"
    ldesc = "You are standing in the northwest end of the Great Hall."
    east = nHall
    se = middleHall
    south = wHall
    seeInto = [ nHall middleHall wHall ]
    isListed = nil
;

candle: lightsource
    location = Me
    noun = 'candle'
    sdesc = "candle"
    islit = true
;

fountain: fixeditem, container
    location = nwHall
    noun = 'fountain'
    sdesc = "fountain"
    isListed = true
;

nHall: room
    sdesc = "North End of Great Hall"
    ldesc = "You are standing in the north end of the Great Hall."
    north = smallDoor
    east = neHall
    se = eHall
    south = middleHall
    sw = wHall
    west = nwHall
    seeInto = [ neHall eHall middleHall wHall nwHall ]
    isListed = nil
;

neHall: room
    sdesc = "Northeast End of Great Hall"
    ldesc = "You are standing in the northeast end of the Great Hall."
    south = eHall
    sw = middleHall
    west = nHall
    seeInto = [ eHall middleHall nHall ]
    isListed = nil
;

smallDoor: door
    noun = 'door'
    adjective = 'small'
    sdesc = "small door"
    foundin = [ nHall, smallPassage ]
;

smallPassage: darkroom
    sdesc = "Small Passage"
    ldesc = "You're at the south end of a very cramped passage. There is
        a door to the south, currently <<smallDoor.isopen ? "open" : "closed">>."
    south = smallDoor
    seeInto = { 
        if (smallDoor.isopen) return nHall;
        return nil;
    }
;
